#include "Goomba.h"
#include "Level.h"

Goomba::Goomba()
{
	walk.addFrame(sf::IntRect(0, 16, 16, 16));		//
	walk.addFrame(sf::IntRect(16, 16, 16, 16));		//		Add the frames from the loaded sprite sheet and set the frame speed
	walk.setFrameSpeed(1.f / 4.f);		//

	dead.addFrame(sf::IntRect(32, 16, 16, 16));		// Add the frame from the sprite sheet

	currentAnimation = &walk;
	setTextureRect(currentAnimation->getCurrentFrame());

	setVelocity(-75, 0);	//-75 to initially walk to the left (toward Mario)

	setCollisionBox(sf::FloatRect(2, 5, 47, 45));

	setSize(sf::Vector2f(50, 50));

	spriteType = SpriteType::GoombaSprite;	//Set the sprite type to a GoombaSprite
}


Goomba::~Goomba()
{
}

void Goomba::kill()
{
	Level::audioManager->playSoundByName("Squish");
	if (!dying)	//If kill has been called and we're not already dying
	{
		dying = true;	//We are now dying, set this to true to begin the death animation
		deathTime = 0.11;	//Set deathTime to 0.11, it will take 0.11s for the death animation to finish
	}

	currentAnimation = &dead;
	setTextureRect(currentAnimation->getCurrentFrame());
	velocity = sf::Vector2f(0, 0);	//Stop all goomba movement
}